% Use "IDXs_new" only for the SAM Analysis
function [sample_to_component pixel_to_component IDXs_new] = assign_regions(Clusters,k, region_overviewn)

RegionsID = unique(region_overviewn);
nr_of_samples = length(RegionsID);
sample_to_component = [];
pixel_to_component = [];
IDXs_new = Clusters;

% 1st way: using maximum fractions
for i=1:nr_of_samples
    % Select spectra of the recent sample
    sampleID = RegionsID(i);
    aa = Clusters(region_overviewn == sampleID,:);
    % Counting contributions of each component to each pixel using maxima
%     [~, b] = max(aa,[],2);
    [counts classes] = hist(aa,unique(aa));
    % If maximum counts are over threshold (>= theoretical fraction), add
    % to assigment list
    threshold = length(aa)/k;  %number of clusters
    for j=1:length(classes)
        if(counts(j) >= threshold)
            sample_to_component = [sample_to_component; [sampleID classes(j)] ];
        else
            jjj = find(aa == classes(j)); 
            aa(jjj) = 0; %Set that subpop to be zeros (it is under the threshold)
            IDXs_new(region_overviewn == sampleID)=aa;
            
        end
    end
    % assign pixel to component
    pixel_to_component(region_overviewn == sampleID) = aa; %label each pixel with its cluster value
end


end

% 2nd way: using correlation coefficients
% threshold = 0.6;
% for i=1:nr_of_samples
%     % Make a working copy of the regions overview
%     aa = reshape(region_overview,x*y,1);
%     % Choose only the sample to work on and set all values to 1
%     aa(aa ~= i) = 0;
%     aa(aa == i) = 1;
%     % Look for components which correlate with sample image
%     for j=1:size(ctdwn,2)
%         coef = corr(aa, ctdwn(:,j));
%         if coef>threshold
%             component_assignment = [component_assignment; [i j] ];
%         end
%     end
% end